/*
 * Decompiled with CFR 0.152.
 */
package com.ceph.rbd;

import com.ceph.rbd.Library;
import com.ceph.rbd.RbdException;
import com.ceph.rbd.jna.RbdImageInfo;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;

public class RbdImage {
    private Pointer image;
    private String name;

    public RbdImage(Pointer pointer, String string) {
        this.image = pointer;
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public Pointer getPointer() {
        return this.image.getPointer(0L);
    }

    public RbdImageInfo stat() throws RbdException {
        RbdImageInfo rbdImageInfo = new RbdImageInfo();
        int n = Library.rbd.rbd_stat(this.getPointer(), rbdImageInfo, 0L);
        if (n < 0) {
            throw new RbdException("Failed to stat the RBD image", n);
        }
        return rbdImageInfo;
    }

    public boolean isOldFormat() throws RbdException {
        IntByReference intByReference = new IntByReference();
        int n = Library.rbd.rbd_get_old_format(this.getPointer(), intByReference);
        if (n < 0) {
            throw new RbdException("Failed to get the RBD format", n);
        }
        return intByReference.getValue() == 1;
    }

    public void snapCreate(String string) throws RbdException {
        int n = Library.rbd.rbd_snap_create(this.getPointer(), string);
        if (n < 0) {
            throw new RbdException("Failed to create snapshot " + string, n);
        }
    }

    public void snapRemove(String string) throws RbdException {
        int n = Library.rbd.rbd_snap_remove(this.getPointer(), string);
        if (n < 0) {
            throw new RbdException("Failed to remove snapshot " + string, n);
        }
    }

    public void snapProtect(String string) throws RbdException {
        int n = Library.rbd.rbd_snap_protect(this.getPointer(), string);
        if (n < 0) {
            throw new RbdException("Failed to protect snapshot " + string, n);
        }
    }

    public void snapUnprotect(String string) throws RbdException {
        int n = Library.rbd.rbd_snap_unprotect(this.getPointer(), string);
        if (n < 0) {
            throw new RbdException("Failed to unprotect snapshot " + string, n);
        }
    }

    public void write(byte[] byArray, long l, int n) throws RbdException {
        if (n < 1) {
            return;
        }
        long l2 = Library.rbd.rbd_write(this.getPointer(), l, n, byArray);
        if (l2 < 0L) {
            throw new RbdException("Failed to write to RBD image", (int)l2);
        }
        if (l2 != (long)n) {
            throw new RbdException("We wrote " + l2 + " bytes while we should have written " + n + " bytes");
        }
    }

    public void write(byte[] byArray, long l) throws RbdException {
        this.write(byArray, l, byArray.length);
    }

    public void write(byte[] byArray) throws RbdException {
        this.write(byArray, 0L, byArray.length);
    }

    public long read(long l, byte[] byArray, long l2) {
        return Library.rbd.rbd_read(this.getPointer(), l, new NativeLong(l2), byArray).longValue();
    }
}

