/*
 * Decompiled with CFR 0.152.
 */
package com.ceph.rbd;

import com.ceph.rbd.Library;
import com.ceph.rbd.RbdException;
import com.ceph.rbd.jna.RbdImageInfo;
import com.ceph.rbd.jna.RbdSnapInfo;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.util.ArrayList;
import java.util.List;

public class RbdImage {
    private Pointer image;
    private String name;

    public RbdImage(Pointer pointer, String string) {
        this.image = pointer;
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public Pointer getPointer() {
        return this.image.getPointer(0L);
    }

    public RbdImageInfo stat() throws RbdException {
        RbdImageInfo rbdImageInfo = new RbdImageInfo();
        int n = Library.rbd.rbd_stat(this.getPointer(), rbdImageInfo, 0L);
        if (n < 0) {
            throw new RbdException("Failed to stat the RBD image", n);
        }
        return rbdImageInfo;
    }

    public boolean isOldFormat() throws RbdException {
        IntByReference intByReference = new IntByReference();
        int n = Library.rbd.rbd_get_old_format(this.getPointer(), intByReference);
        if (n < 0) {
            throw new RbdException("Failed to get the RBD format", n);
        }
        return intByReference.getValue() == 1;
    }

    public void snapCreate(String string) throws RbdException {
        int n = Library.rbd.rbd_snap_create(this.getPointer(), string);
        if (n < 0) {
            throw new RbdException("Failed to create snapshot " + string, n);
        }
    }

    public void snapRemove(String string) throws RbdException {
        int n = Library.rbd.rbd_snap_remove(this.getPointer(), string);
        if (n < 0) {
            throw new RbdException("Failed to remove snapshot " + string, n);
        }
    }

    public void snapProtect(String string) throws RbdException {
        int n = Library.rbd.rbd_snap_protect(this.getPointer(), string);
        if (n < 0) {
            throw new RbdException("Failed to protect snapshot " + string, n);
        }
    }

    public void snapUnprotect(String string) throws RbdException {
        int n = Library.rbd.rbd_snap_unprotect(this.getPointer(), string);
        if (n < 0) {
            throw new RbdException("Failed to unprotect snapshot " + string, n);
        }
    }

    public boolean snapIsProtected(String string) throws RbdException {
        IntByReference intByReference = new IntByReference();
        int n = Library.rbd.rbd_snap_is_protected(this.getPointer(), string, intByReference);
        if (n < 0) {
            throw new RbdException("Failed to find out if snapshot " + string + " is protected", n);
        }
        return intByReference.getValue() == 1;
    }

    public List<RbdSnapInfo> snapList() throws RbdException {
        IntByReference intByReference = new IntByReference(16);
        PointerByReference pointerByReference = new PointerByReference();
        ArrayList<RbdSnapInfo> arrayList = new ArrayList<RbdSnapInfo>();
        int n = Library.rbd.rbd_snap_list(this.getPointer(), pointerByReference, intByReference);
        if (n < 0) {
            throw new RbdException("Failed listing snapshots", n);
        }
        intByReference.setValue(n);
        Pointer pointer = pointerByReference.getValue();
        RbdSnapInfo rbdSnapInfo = new RbdSnapInfo(pointer);
        RbdSnapInfo[] rbdSnapInfoArray = (RbdSnapInfo[])rbdSnapInfo.toArray(intByReference.getValue());
        for (int i = 0; i < intByReference.getValue(); ++i) {
            arrayList.add(rbdSnapInfoArray[i]);
        }
        Library.rbd.rbd_snap_list_end(pointerByReference);
        return arrayList;
    }

    public void write(byte[] byArray, long l, int n) throws RbdException {
        if (n < 1) {
            throw new RbdException("There should be at least one byte to write");
        }
        int n2 = Library.rbd.rbd_write(this.getPointer(), l, n, byArray);
        if (n2 < 0) {
            throw new RbdException("Failed writing " + n + " bytes starting at offset " + l, n2);
        }
    }

    public void write(byte[] byArray, long l) throws RbdException {
        this.write(byArray, l, byArray.length);
    }

    public void write(byte[] byArray) throws RbdException {
        this.write(byArray, 0L, byArray.length);
    }

    public int read(long l, byte[] byArray, int n) {
        return Library.rbd.rbd_read(this.getPointer(), l, n, byArray);
    }
}

