/*
 * Decompiled with CFR 0.152.
 */
package com.ceph.rados;

import com.ceph.rados.Library;
import com.ceph.rados.RadosException;
import com.ceph.rados.jna.RadosObjectInfo;
import com.ceph.rados.jna.RadosPoolInfo;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.LongByReference;
import java.util.ArrayList;

public class IoCTX {
    private Pointer ioCtxPtr;

    public IoCTX(Pointer pointer) {
        this.ioCtxPtr = pointer;
    }

    public Pointer getPointer() {
        return this.ioCtxPtr.getPointer(0L);
    }

    public long getId() {
        return Library.rados.rados_ioctx_get_id(this.getPointer());
    }

    public void setAuid(long l) throws RadosException {
        int n = Library.rados.rados_ioctx_pool_set_auid(this.getPointer(), l);
        if (n < 0) {
            throw new RadosException("Failed to set the auid to " + l, n);
        }
    }

    public long getAuid() throws RadosException {
        LongByReference longByReference = new LongByReference();
        int n = Library.rados.rados_ioctx_pool_get_auid(this.getPointer(), longByReference);
        if (n < 0) {
            throw new RadosException("Failed to get the auid", n);
        }
        return longByReference.getValue();
    }

    public String getPoolName() throws RadosException {
        byte[] byArray = new byte[1024];
        int n = Library.rados.rados_ioctx_get_pool_name(this.getPointer(), byArray, byArray.length);
        if (n < 0) {
            throw new RadosException("Failed to get the pool name", n);
        }
        return Native.toString((byte[])byArray);
    }

    public void locatorSetKey(String string) {
        Library.rados.rados_ioctx_locator_set_key(this.getPointer(), string);
    }

    public String[] listObjects() throws RadosException {
        Memory memory = new Memory((long)Pointer.SIZE);
        ArrayList<String> arrayList = new ArrayList<String>();
        Memory memory2 = new Memory((long)Pointer.SIZE);
        int n = Library.rados.rados_objects_list_open(this.getPointer(), (Pointer)memory2);
        if (n < 0) {
            throw new RadosException("Failed listing all objects", n);
        }
        while (Library.rados.rados_objects_list_next(memory2.getPointer(0L), (Pointer)memory, null) == 0) {
            arrayList.add(memory.getPointer(0L).getString(0L));
        }
        Library.rados.rados_objects_list_close(memory2.getPointer(0L));
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public void write(String string, byte[] byArray, long l) throws RadosException, IllegalArgumentException {
        if (l < 0L) {
            throw new IllegalArgumentException("Offset shouldn't be a negative value");
        }
        int n = Library.rados.rados_write(this.getPointer(), string, byArray, byArray.length, l);
        if (n < 0) {
            throw new RadosException("Failed writing " + byArray.length + " bytes with offset " + l + " to " + string, n);
        }
    }

    public void write(String string, byte[] byArray) throws RadosException {
        this.writeFull(string, byArray, byArray.length);
    }

    public void writeFull(String string, byte[] byArray, int n) throws RadosException {
        int n2 = Library.rados.rados_write_full(this.getPointer(), string, byArray, n);
        if (n2 < 0) {
            throw new RadosException("Failed writing " + n + " bytes to " + string, n2);
        }
    }

    public void write(String string, String string2, long l) throws RadosException {
        this.write(string, string2.getBytes(), l);
    }

    public void write(String string, String string2) throws RadosException {
        this.write(string, string2.getBytes());
    }

    public void remove(String string) throws RadosException {
        int n = Library.rados.rados_remove(this.getPointer(), string);
        if (n < 0) {
            throw new RadosException("Failed removing " + string, n);
        }
    }

    public int read(String string, int n, long l, byte[] byArray) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("Length shouldn't be a negative value");
        }
        if (l < 0L) {
            throw new IllegalArgumentException("Offset shouldn't be a negative value");
        }
        return Library.rados.rados_read(this.getPointer(), string, byArray, n, l);
    }

    public void truncate(String string, long l) throws RadosException, IllegalArgumentException {
        if (l < 0L) {
            throw new IllegalArgumentException("Size shouldn't be a negative value");
        }
        int n = Library.rados.rados_trunc(this.getPointer(), string, l);
        if (n < 0) {
            throw new RadosException("Failed resizing " + string + " to " + l + " bytes", n);
        }
    }

    public void append(String string, byte[] byArray) throws RadosException {
        this.append(string, byArray, byArray.length);
    }

    public void append(String string, byte[] byArray, int n) throws RadosException {
        int n2 = Library.rados.rados_append(this.getPointer(), string, byArray, n);
        if (n2 < 0) {
            throw new RadosException("Failed appending " + n + " bytes to " + string, n2);
        }
    }

    public void append(String string, String string2) throws RadosException {
        this.append(string, string2.getBytes());
    }

    public void clone(String string, long l, String string2, long l2, long l3) throws RadosException {
        int n = Library.rados.rados_clone_range(this.getPointer(), string, l, string2, l2, l3);
        if (n < 0) {
            throw new RadosException("Failed to copy " + l3 + " bytes from " + string2 + " to " + string, n);
        }
    }

    public RadosObjectInfo stat(String string) throws RadosException {
        LongByReference longByReference = new LongByReference();
        LongByReference longByReference2 = new LongByReference();
        int n = Library.rados.rados_stat(this.getPointer(), string, longByReference, longByReference2);
        if (n < 0) {
            throw new RadosException("Failed performing a stat on " + string, n);
        }
        return new RadosObjectInfo(string, longByReference.getValue(), longByReference2.getValue());
    }

    public RadosPoolInfo poolStat() throws RadosException {
        RadosPoolInfo radosPoolInfo = new RadosPoolInfo();
        int n = Library.rados.rados_ioctx_pool_stat(this.getPointer(), radosPoolInfo);
        if (n < 0) {
            throw new RadosException("Failed retrieving the pool stats", n);
        }
        return radosPoolInfo;
    }

    public void snapCreate(String string) throws RadosException {
        int n = Library.rados.rados_ioctx_snap_create(this.getPointer(), string);
        if (n < 0) {
            throw new RadosException("Failed to create snapshot " + string, n);
        }
    }

    public void snapRemove(String string) throws RadosException {
        int n = Library.rados.rados_ioctx_snap_remove(this.getPointer(), string);
        if (n < 0) {
            throw new RadosException("Failed to remove snapshot " + string, n);
        }
    }

    public long snapLookup(String string) throws RadosException {
        LongByReference longByReference = new LongByReference();
        int n = Library.rados.rados_ioctx_snap_lookup(this.getPointer(), string, longByReference);
        if (n < 0) {
            throw new RadosException("Failed to lookup the ID of snapshot " + string, n);
        }
        return longByReference.getValue();
    }

    public String snapGetName(long l) throws RadosException {
        byte[] byArray = new byte[512];
        int n = Library.rados.rados_ioctx_snap_get_name(this.getPointer(), l, byArray, byArray.length);
        if (n < 0) {
            throw new RadosException("Failed to lookup the name of snapshot " + l, n);
        }
        return new String(byArray).trim();
    }

    public long snapGetStamp(long l) throws RadosException {
        LongByReference longByReference = new LongByReference();
        int n = Library.rados.rados_ioctx_snap_get_stamp(this.getPointer(), l, longByReference);
        if (n < 0) {
            throw new RadosException("Failed to retrieve the timestamp of snapshot " + l, n);
        }
        return longByReference.getValue();
    }

    public Long[] snapList() throws RadosException {
        byte[] byArray = new byte[512];
        int n = Library.rados.rados_ioctx_snap_list(this.getPointer(), byArray, byArray.length);
        if (n < 0) {
            throw new RadosException("Failed to list all snapshots", n);
        }
        Long[] longArray = new Long[n];
        for (int i = 0; i < n; ++i) {
            longArray[i] = new Long(byArray[i]);
        }
        return longArray;
    }
}

