/*
 * Decompiled with CFR 0.152.
 */
package com.ceph.rados;

import com.ceph.rados.Library;
import com.ceph.rados.ListCtx;
import com.ceph.rados.RadosBase;
import com.ceph.rados.ReadOp;
import com.ceph.rados.exceptions.RadosException;
import com.ceph.rados.jna.RadosObjectInfo;
import com.ceph.rados.jna.RadosPoolInfo;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.LongByReference;
import java.util.ArrayList;
import java.util.concurrent.Callable;

public class IoCTX
extends RadosBase {
    private static final int EXT_ATTR_MAX_LEN = 4096;
    private Pointer ioCtxPtr;

    public IoCTX(Pointer p) {
        this.ioCtxPtr = p;
    }

    public Pointer getPointer() {
        return this.ioCtxPtr.getPointer(0L);
    }

    public long getId() {
        return Library.rados.rados_ioctx_get_id(this.getPointer());
    }

    public void setAuid(final long auid) throws RadosException {
        this.handleReturnCode(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return Library.rados.rados_ioctx_pool_set_auid(IoCTX.this.getPointer(), auid);
            }
        }, "Failed to set the auid to %s", auid);
    }

    public long getAuid() throws RadosException {
        final LongByReference auid = new LongByReference();
        this.handleReturnCode(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return Library.rados.rados_ioctx_pool_get_auid(IoCTX.this.getPointer(), auid);
            }
        }, "Failed to get the auid", new Object[0]);
        return auid.getValue();
    }

    public String getPoolName() throws RadosException {
        final byte[] buf = new byte[1024];
        this.handleReturnCode(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return Library.rados.rados_ioctx_get_pool_name(IoCTX.this.getPointer(), buf, buf.length);
            }
        }, "Failed to get the pool name", new Object[0]);
        return Native.toString((byte[])buf);
    }

    public void locatorSetKey(String key) {
        Library.rados.rados_ioctx_locator_set_key(this.getPointer(), key);
    }

    public String[] listObjects() throws RadosException {
        Memory entry = new Memory((long)Pointer.SIZE);
        ArrayList<String> objects = new ArrayList<String>();
        Memory list = new Memory((long)Pointer.SIZE);
        this.handleReturnCode(new Callable<Integer>((Pointer)list){
            final /* synthetic */ Pointer val$list;
            {
                this.val$list = pointer;
            }

            @Override
            public Integer call() throws Exception {
                return Library.rados.rados_objects_list_open(IoCTX.this.getPointer(), this.val$list);
            }
        }, "Failed starting to list all objects", new Object[0]);
        while (Library.rados.rados_objects_list_next(list.getPointer(0L), (Pointer)entry, null) == 0) {
            objects.add(entry.getPointer(0L).getString(0L));
        }
        Library.rados.rados_objects_list_close(list.getPointer(0L));
        return objects.toArray(new String[objects.size()]);
    }

    public ListCtx listObjectsPartial(int limit) throws RadosException {
        Memory list = new Memory((long)Pointer.SIZE);
        int r = Library.rados.rados_objects_list_open(this.getPointer(), (Pointer)list);
        if (r < 0) {
            throw new RadosException("Failed listing all objects", r);
        }
        return new ListCtx(limit, (Pointer)list);
    }

    public void write(final String oid, final byte[] buf, final long offset) throws RadosException, IllegalArgumentException {
        if (offset < 0L) {
            throw new IllegalArgumentException("Offset shouldn't be a negative value");
        }
        this.handleReturnCode(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return Library.rados.rados_write(IoCTX.this.getPointer(), oid, buf, buf.length, offset);
            }
        }, "Failed writing %s bytes with offset %s to %s", buf.length, offset, oid);
    }

    public void write(String oid, byte[] buf) throws RadosException {
        this.writeFull(oid, buf, buf.length);
    }

    public void writeFull(final String oid, final byte[] buf, final int len) throws RadosException {
        this.handleReturnCode(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return Library.rados.rados_write_full(IoCTX.this.getPointer(), oid, buf, len);
            }
        }, "Failed to write %s bytes to %s", len, oid);
    }

    public void write(String oid, String buf, long offset) throws RadosException {
        this.write(oid, buf.getBytes(), offset);
    }

    public void write(String oid, String buf) throws RadosException {
        this.write(oid, buf.getBytes());
    }

    public void remove(final String oid) throws RadosException {
        this.handleReturnCode(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return Library.rados.rados_remove(IoCTX.this.getPointer(), oid);
            }
        }, "Failed removing object %s", oid);
    }

    public int read(final String oid, final int length, final long offset, final byte[] buf) throws RadosException {
        if (length < 0) {
            throw new IllegalArgumentException("Length shouldn't be a negative value");
        }
        if (offset < 0L) {
            throw new IllegalArgumentException("Offset shouldn't be a negative value");
        }
        return this.handleReturnCode(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return Library.rados.rados_read(IoCTX.this.getPointer(), oid, buf, length, offset);
            }
        }, "Failed to read object %s using offset %s and length %s", oid, offset, length);
    }

    public void truncate(final String oid, final long size) throws RadosException {
        if (size < 0L) {
            throw new IllegalArgumentException("Size shouldn't be a negative value");
        }
        this.handleReturnCode(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return Library.rados.rados_trunc(IoCTX.this.getPointer(), oid, size);
            }
        }, "Failed resizing objects %s to %s bytes", oid, size);
    }

    public void append(String oid, byte[] buf) throws RadosException {
        this.append(oid, buf, buf.length);
    }

    public void append(final String oid, final byte[] buf, final int len) throws RadosException {
        this.handleReturnCode(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return Library.rados.rados_append(IoCTX.this.getPointer(), oid, buf, len);
            }
        }, "Failed appending %s bytes to object %s", len, oid);
    }

    public void append(String oid, String buf) throws RadosException {
        this.append(oid, buf.getBytes());
    }

    public void clone(final String dst, final long dst_off, final String src, final long src_off, final long len) throws RadosException {
        this.handleReturnCode(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return Library.rados.rados_clone_range(IoCTX.this.getPointer(), dst, dst_off, src, src_off, len);
            }
        }, "Failed to copy %s bytes from %s to %s", len, src, dst);
    }

    public RadosObjectInfo stat(final String oid) throws RadosException {
        final LongByReference size = new LongByReference();
        final LongByReference mtime = new LongByReference();
        this.handleReturnCode(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return Library.rados.rados_stat(IoCTX.this.getPointer(), oid, size, mtime);
            }
        }, "Failed performing a stat on object %s", oid);
        return new RadosObjectInfo(oid, size.getValue(), mtime.getValue());
    }

    public RadosPoolInfo poolStat() throws RadosException {
        final RadosPoolInfo result = new RadosPoolInfo();
        this.handleReturnCode(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return Library.rados.rados_ioctx_pool_stat(IoCTX.this.getPointer(), result);
            }
        }, "Failed retrieving the pool stats", new Object[0]);
        return result;
    }

    public void snapCreate(final String snapname) throws RadosException {
        this.handleReturnCode(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return Library.rados.rados_ioctx_snap_create(IoCTX.this.getPointer(), snapname);
            }
        }, "Failed to create snapshot %s", snapname);
    }

    public void snapRemove(final String snapname) throws RadosException {
        this.handleReturnCode(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return Library.rados.rados_ioctx_snap_remove(IoCTX.this.getPointer(), snapname);
            }
        }, "Failed to remove snapshot %s", snapname);
    }

    public long snapLookup(final String snapname) throws RadosException {
        final LongByReference id = new LongByReference();
        this.handleReturnCode(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return Library.rados.rados_ioctx_snap_lookup(IoCTX.this.getPointer(), snapname, id);
            }
        }, "Failed to lookup the ID of snapshot %s", snapname);
        return id.getValue();
    }

    public String snapGetName(final long id) throws RadosException {
        final byte[] buf = new byte[512];
        this.handleReturnCode(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return Library.rados.rados_ioctx_snap_get_name(IoCTX.this.getPointer(), id, buf, buf.length);
            }
        }, "Failed to lookup the name of snapshot %s", id);
        return new String(buf).trim();
    }

    public long snapGetStamp(final long id) throws RadosException {
        final LongByReference time = new LongByReference();
        this.handleReturnCode(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return Library.rados.rados_ioctx_snap_get_stamp(IoCTX.this.getPointer(), id, time);
            }
        }, "Failed to retrieve the timestamp of snapshot %s", id);
        return time.getValue();
    }

    public Long[] snapList() throws RadosException {
        final byte[] buf = new byte[512];
        Integer result = this.handleReturnCode(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return Library.rados.rados_ioctx_snap_list(IoCTX.this.getPointer(), buf, buf.length);
            }
        }, "Failed to list all snapshots", new Object[0]);
        Long[] snaps = new Long[result.intValue()];
        for (int i = 0; i < result; ++i) {
            snaps[i] = buf[i];
        }
        return snaps;
    }

    public ReadOp readOpCreate() {
        return new ReadOp(this.getPointer(), Library.rados.rados_create_read_op());
    }

    public void readOpRelease(ReadOp read_op) {
        Library.rados.rados_release_read_op(read_op.getPointer());
    }

    public String getExtentedAttribute(final String oid, final String xattrName) throws RadosException {
        final byte[] buf = new byte[4096];
        this.handleReturnCode(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return Library.rados.rados_getxattr(IoCTX.this.getPointer(), oid, xattrName, buf, buf.length);
            }
        }, "Failed to get extended attribute %s on %s", xattrName, oid);
        return Native.toString((byte[])buf);
    }

    public void setExtentedAttribute(final String oid, final String xattrName, String val) throws IllegalArgumentException, RadosException {
        final byte[] buf = Native.toByteArray((String)val);
        if (buf.length > 4096) {
            throw new IllegalArgumentException("Length of attribute value must not exceed 4096");
        }
        this.handleReturnCode(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return Library.rados.rados_setxattr(IoCTX.this.getPointer(), oid, xattrName, buf, buf.length);
            }
        }, "Failed to set extended attribute %s on %s", xattrName, oid);
    }

    public void removeExtentedAttribute(final String oid, final String xattrName) throws RadosException {
        this.handleReturnCode(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return Library.rados.rados_rmxattr(IoCTX.this.getPointer(), oid, xattrName);
            }
        }, "Failed to remove extended attribute %s from %s", xattrName, oid);
    }
}

