/*
 * Decompiled with CFR 0.152.
 */
package com.ceph.rbd;

import com.ceph.rbd.Library;
import com.ceph.rbd.RbdException;
import com.ceph.rbd.jna.RbdImageInfo;
import com.ceph.rbd.jna.RbdSnapInfo;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class RbdImage {
    private Pointer image;
    private String name;

    public RbdImage(Pointer image, String name) {
        this.image = image;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Pointer getPointer() {
        return this.image.getPointer(0L);
    }

    public RbdImageInfo stat() throws RbdException {
        RbdImageInfo info = new RbdImageInfo();
        int r = Library.rbd.rbd_stat(this.getPointer(), info, 0L);
        if (r < 0) {
            throw new RbdException("Failed to stat the RBD image", r);
        }
        return info;
    }

    public boolean isOldFormat() throws RbdException {
        IntByReference old = new IntByReference();
        int r = Library.rbd.rbd_get_old_format(this.getPointer(), old);
        if (r < 0) {
            throw new RbdException("Failed to get the RBD format", r);
        }
        return old.getValue() == 1;
    }

    public void snapCreate(String snapName) throws RbdException {
        int r = Library.rbd.rbd_snap_create(this.getPointer(), snapName);
        if (r < 0) {
            throw new RbdException("Failed to create snapshot " + snapName, r);
        }
    }

    public void snapRemove(String snapName) throws RbdException {
        int r = Library.rbd.rbd_snap_remove(this.getPointer(), snapName);
        if (r < 0) {
            throw new RbdException("Failed to remove snapshot " + snapName, r);
        }
    }

    public void snapProtect(String snapName) throws RbdException {
        int r = Library.rbd.rbd_snap_protect(this.getPointer(), snapName);
        if (r < 0) {
            throw new RbdException("Failed to protect snapshot " + snapName, r);
        }
    }

    public void snapUnprotect(String snapName) throws RbdException {
        int r = Library.rbd.rbd_snap_unprotect(this.getPointer(), snapName);
        if (r < 0) {
            throw new RbdException("Failed to unprotect snapshot " + snapName, r);
        }
    }

    public boolean snapIsProtected(String snapName) throws RbdException {
        IntByReference isProtected = new IntByReference();
        int r = Library.rbd.rbd_snap_is_protected(this.getPointer(), snapName, isProtected);
        if (r < 0) {
            throw new RbdException("Failed to find out if snapshot " + snapName + " is protected", r);
        }
        return isProtected.getValue() == 1;
    }

    public List<RbdSnapInfo> snapList() throws RbdException {
        return this.snapList(128);
    }

    public List<RbdSnapInfo> snapList(int initialBufferSize) throws RbdException {
        RbdSnapInfo[] snaps;
        int snapCount;
        IntByReference maxSnaps = new IntByReference(initialBufferSize);
        do {
            snaps = new RbdSnapInfo[maxSnaps.getValue()];
        } while ((snapCount = Library.rbd.rbd_snap_list(this.getPointer(), snaps, maxSnaps)) == -34);
        if (snapCount < 0) {
            throw new RbdException("Failed to list snapshots", snapCount);
        }
        for (int i = 0; i < snapCount; ++i) {
            snaps[i].setAutoSynch(false);
        }
        Library.rbd.rbd_snap_list_end(snaps);
        return Arrays.asList(snaps).subList(0, snapCount);
    }

    public void write(byte[] data, long offset, int length) throws RbdException {
        if (length < 1) {
            throw new RbdException("There should be at least one byte to write");
        }
        int r = Library.rbd.rbd_write(this.getPointer(), offset, length, data);
        if (r < 0) {
            throw new RbdException("Failed writing " + length + " bytes starting at offset " + offset, r);
        }
    }

    public void write(byte[] data, long offset) throws RbdException {
        this.write(data, offset, data.length);
    }

    public void write(byte[] data) throws RbdException {
        this.write(data, 0L, data.length);
    }

    public int read(long offset, byte[] buffer, int length) {
        return Library.rbd.rbd_read(this.getPointer(), offset, length, buffer);
    }

    public void resize(long size) throws RbdException {
        int r = Library.rbd.rbd_resize(this.getPointer(), size);
        if (r < 0) {
            throw new RbdException("Failed to resize the RBD image", r);
        }
    }

    public void flatten() throws RbdException {
        int r = Library.rbd.rbd_flatten(this.getPointer());
        if (r < 0) {
            throw new RbdException("Failed to flatten the RBD image", r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> listChildren(String snapname) throws RbdException {
        int r = Library.rbd.rbd_snap_set(this.getPointer(), snapname);
        if (r < 0) {
            throw new RbdException("Failed to set snapshot name to " + snapname, r);
        }
        try {
            byte[] images;
            byte[] pools;
            int childCount;
            int initialBufferSize = 1024;
            IntByReference poolBufferSize = new IntByReference(initialBufferSize);
            IntByReference imageBufferSize = new IntByReference(initialBufferSize);
            do {
                pools = new byte[poolBufferSize.getValue()];
                images = new byte[imageBufferSize.getValue()];
            } while ((childCount = Library.rbd.rbd_list_children(this.getPointer(), pools, poolBufferSize, images, imageBufferSize)) == -34);
            if (childCount < 0) {
                throw new RbdException("Failed to list snap children", r);
            }
            ArrayList<String> poolImageList = new ArrayList<String>();
            if (childCount > 0) {
                String[] imageNames;
                String[] poolNames = new String(pools).split("\u0000");
                if (poolNames.length != (imageNames = new String(images).split("\u0000")).length) {
                    throw new RbdException("Mismatch between number of pools and images, pools = " + poolNames.length + ", images = " + imageNames.length);
                }
                for (int i = 0; i < poolNames.length; ++i) {
                    poolImageList.add(poolNames[i] + '/' + imageNames[i]);
                }
            }
            ArrayList<String> arrayList = poolImageList;
            return arrayList;
        }
        finally {
            Library.rbd.rbd_snap_set(this.getPointer(), new String());
        }
    }
}

